<?php 

/**
* Generic template that can be used as the container for fancybox form dialogs.
*
* The template includes javascript that will ensure that the form automatically remains in the fancybox window after submission, making it easy to write standard form markup that will work 
* whether or not it's inside a fancybox dialog.  This template also includes javascript that will add the window title, instructions, and any validation messages to the screen-reader.
*
* There are a number of optional paramaters that can be passed to this template:
* # $header - Title of this window
* # $subheader - Main instructions for this window, will be displayed as a paragraph immediately after the header
* # $danger_message - Text that should be displayed as an error/red alert message.  This will be displayed after the $subheader.
* # $warning_message - Text that should be displayed as a warning/yellow alert message.  This will be displayed after the $subheader.
* # $success_message - Text to indicate that something has successfully completed.  This will be displayd after the $subheader
*
* @todo Better organize CSS and move it elsewhere
* @todo Progress indicator when loading form responses?
* @author M. Gibbs <gibbs_margaret@bah.com>
* @package direct-project-innovation-initiative
* @subpackage views
*/


//header, subheader are optional parameters that may be passed to the template - default to '' if they're not passed
foreach( array('header', 'subheader', ) as $var){
	if(!isset($$var)) $$var = '';
}

//default to '' if the messages aren't passed
$messages = array();
foreach(array('danger_message', 'success_message', 'warning_message') as $message_var){
	if(!empty($$message_var)) $messages[$message_var] = $$message_var;
}

//prep an amalgamation of the text on this page for the accessibility js - should not contain HTML, new lines, or single quotes.  (better way of doing this?)
$accessibility_message = str_replace("'", "\'", str_replace("\n", ' ',  str_replace("\r", ' ', strip_tags($header.'. '.$subheader.' '.implode(' ', $messages)))));

?>
<!doctype html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<?php if(!IS_AJAX): ?><link href="<?php echo site_url('css/main.css') ?>" rel="stylesheet" type="text/css" media="all" />
	<link href="<?php echo site_url('css/bootstrap-scoped.min.css') ?>" rel="stylesheet" type="text/css" media="all" />
	<link href="<?php echo site_url('css/localized.css') ?>" rel="stylesheet" type="text/css" media="all" /><?php endif ?>
</head>
<body>
 	<div id="form-dialog-container" class="bootstrap form-dialog-container <?php echo make_string_css_friendly(get_class(get_instance())) ?> <?php echo make_string_css_friendly(get_instance()->router->fetch_method()) ?>">
		<div class="form-dialog"> 
			<?php if(!empty($header)): ?><h3><?php echo $header ?></h3><?php endif ?>
			<?php if(!empty($subheader)): ?><p><?php echo $subheader ?></p><?php endif ?>
		<?php foreach($messages as $message_type => $message): ?>
			<?php if(!empty($message)): ?><div class="feedback-message alert alert-<?php echo strip_from_end('_message', $message_type) ?>"><?php echo $message ?></div><?php endif ?>
		<?php endforeach ?>	
			<?php echo $contents ?>
		</div>
	</div> 
	<script>
		$(document).ready( function() {		
			$('#form-dialog-container form input[type="submit"]').click( function(){ 
				//since we're submitting the forms via ajax, make sure the submit values have a corresponding hidden field to indicate which button we've pressed
				$(this).after('<input type="hidden" name="' + $(this).attr('name') + '" value="' + $(this).attr('value') + '" />'); 
			});	
			
			$('#form-dialog-container form').submit(function() { //catch the form submission event so that we can keep the results in fancybox 
				$.fancybox({
	 				type: 'ajax',
					href: $(this).attr('action'),
					ajax: { data: $(this).serialize(), type: $(this).attr('method')},
				/*	autoDimensions: false, /* avoiding the need for this by sitting a max-height on the panel and applying overflow auto - worked in IE8
					height: $(window).height()*0.85,
					width: 'auto', */
				});
				return false;
			});	
			
			//for the ssn field, jump automatically to the next text input when the user has finished the current one
			$('.social-security-number-form-control-container').keyup(function(event){
				if ( event.which >= 48 && event.which <= 57 ) { //numbers
					if($(event.target).val().length == $(event.target).attr('maxlength')){
						$(event.target).nextAll('input').first().focus();
					}
				}
			});			
			
			$('#StatusUpdater').html('<?php echo $accessibility_message ?>'); //ensures that screenreaders see this text
		} );
	</script>
</body>
</html>